%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Monte-Carlo simulation of L96 model for comparison
% in Example 4.9 and 4.10
% Created by John Harlim
% Last edited: March 20, 2018
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


clear all, close all

N = 5;                      % model dimension
T = 100;                    % integration length
K = 10000;                  % ensemble size
dt = 0.05;                  % integration time step
u = zeros(N,K,T+1);
u0 = sin([1:N]*2*pi/N)';    % initial condition

Y = 2*rand(2,K)-1;
theta1 = 1+.2*Y(1,:);
theta2 = 8+Y(2,:);

% integrating L96 with Runge-Kutta-4 method
for j=1:K
    u(:,j,:) = l96rk4(theta1(j),theta2(j),u0,T);
end

% compute statistics
ubar = mean(u,2);
vbar = squeeze(sqrt(mean((u - repmat(ubar,1,K,1)).^2,2)));
ubar = squeeze(ubar);

mode = 5;
plot([0:dt:dt*T],ubar(mode,:),'k')
hold on
plot([0:dt:dt*T],ubar(mode,:)+sqrt(vbar(mode,:)),'k--')
plot([0:dt:dt*T],ubar(mode,:)-sqrt(vbar(mode,:)),'k--')
hold off
set(gca,'fontsize',16)
xlabel('time')
ylabel('u_5')

%
save montecarloL965D ubar vbar dt 

%print -deps -r100 montecarloL965D.eps

